﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

//MEF
using System.ComponentModel.Composition;
using System.ComponentModel.Composition.Hosting;

namespace MEF_gospodarz
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();            
        }

        private void button1_Click(object sender, EventArgs e)
        {
            MefGospodarz gospodarz = new MefGospodarz();
            gospodarz.Compose();
            gospodarz.Run();
        }
    }

    class MefGospodarz
    {
        [Import]
        public IMessageSender MessageSender { get; set; }

        public void Compose()
        {
            CompositionContainer pojemnik = new CompositionContainer();
            pojemnik.ComposeParts(this, new MessageBoxSender());
        }

        public void Run()
        {
            if (MessageSender != null)
            {
                if (!MessageSender.Send("Treść wiadomości"))
                    MessageBox.Show("Nie udało się dostarczyć wiadomości");
            }
            else MessageBox.Show("Brak wtyczki pozwalającej na dostarczenie wiadomości");
        }
    }

    public interface IMessageSender
    {
        bool Send(string message);
    }

    [Export(typeof(IMessageSender))]
    public class MessageBoxSender : IMessageSender
    {
        public bool Send(string message)
        {
            MessageBox.Show(message,"Komunikat");
            return true;
        }
    }
}
